# External coupling

"External coupling" is a library attribute used to specify the custom
mechanisms and algorithms provided. It is mainly used for libraries to specify
additional functionalities relevant to the modelling method it is realizing.
These are in addition to the functionalities provided by the platform out of
the box. The definition of the External coupling attribute is centered around
triggers and the scripts to execute when they are encountered.



## External coupling for Libraries

Two types of triggers can be specified through the "External coupling"
attribute of a library: adding items to the menu bar through the `ITEM` command
(see [Menus and Buttons](Menus%20and%20Buttons.md)) and events through the
`ON_EVENT` command (see [Application events](Events/Application%20events.md))
of which the most notable is the `ON_EVENT "AppInitialized"`.

The extensions specified are available in the Modelling Toolkit with the
loaded library.



## External coupling for Development Toolkit

It is also possible to specify an "External coupling" for the Development
Toolkit. Similar to the ones for libraries it allows to specify two types of
triggers: adding items to the menu bar through the `ITEM` command
(see [Menus and Buttons](Menus%20and%20Buttons.md)) and events through the
`ON_DEV_EVENT` command (see [Application events](Events/Application%20events.md)).

The `ITEM` command works the same way as for libraries with one difference. The
allowed values for the component name must be one of `usermgt`, `librarymgt`,
`modelmgt`, `attrprofmgt` or `configmgt`.

The Development Toolkit does not have a specific library with an attribute to
edit. Instead the "External coupling" for the Development Toolkit is specified
through a file `ado_dev_coupling.asc` as part of the database and must be on
root level (not part of any library). This file can be imported and exported
through the "Extras -> File management..." menu. This also means that it can
not use any library related procedures.

Example for a simple menu item added to the "Library management" component:

```AdoScript
ITEM "My own library management" librarymgt:"Customized Management"
CC "AdoScript" INFOBOX "Customized management is called."
```
